# Extension Icons

This directory contains placeholder icon files for the Chrome extension:

- ✓ `icon16.png` - 16x16 pixels (toolbar icon)
- ✓ `icon48.png` - 48x48 pixels (extension management page)
- ✓ `icon128.png` - 128x128 pixels (Chrome Web Store)

## Current Design

The placeholder icons feature:
- Green background (#4CAF50) - matches extension theme
- Russian "Б" → English "B" with arrow
- Represents translation/language conversion
- Rounded corners for modern look

## Regenerating Icons

If you need to recreate the icons, run:

```bash
node scripts/create-icons.js
```

This uses the `canvas` package to generate PNG files programmatically.

## Custom Icons

To create custom icons, you can:

1. Use an image editor (Photoshop, GIMP, Figma)
2. Use online icon generators:
   - https://www.favicon-generator.org/
   - https://favicon.io/
   - https://realfavicongenerator.net/
3. Design at 128x128 and scale down for smaller sizes
4. Ensure icons are recognizable at 16x16 size
