// js/config.js
var Config = {
  // API Configuration
  API_URL: "https://translate-api-70536743886.europe-west4.run.app/translate",
  // Cache Configuration
  CACHE_MAX_SIZE: 200,
  CACHE_STORAGE_KEY: "translationCache",
  // Timing Constants (in milliseconds)
  TIMING: {
    INIT_DELAY: 500,
    PAGE_LOAD_CHECK: 1e3,
    API_TIMEOUT: 5e3,
    STATUS_DISPLAY: 5e3,
    MAX_INIT_ATTEMPTS: 3
  },
  // DOM Selectors
  SELECTORS: {
    // Chat input selectors
    MAIN_CHAT_INPUT: '.theatermodeInputFieldChat[contenteditable="true"]',
    PM_CHAT_INPUT: '.theatermodeInputFieldPm[contenteditable="true"]',
    CHAT_INPUT_FIELD: '.chat-input-field[contenteditable="true"]',
    CHAT_INPUT_TESTID: '[data-testid="chat-input"][contenteditable="true"]',
    // Chat message selectors
    CHAT_MESSAGE: '[data-testid="chat-message"]',
    CHAT_MESSAGE_TEXT: '[data-testid="chat-message-text"]',
    MSG_LIST_WRAPPER: ".msg-list-wrapper-split"
  },
  // Theme Colors
  COLORS: {
    // Backgrounds
    BG_PRIMARY: "rgba(17, 24, 39, 0.95)",
    BG_INPUT: "rgba(255, 255, 255, 0.1)",
    BG_INPUT_FOCUS: "rgba(255, 255, 255, 0.15)",
    BG_BUTTON: "rgba(255, 255, 255, 0.05)",
    BG_BUTTON_HOVER: "rgba(255, 255, 255, 0.15)",
    // Borders
    BORDER_DEFAULT: "rgba(255, 255, 255, 0.3)",
    BORDER_FOCUS: "rgba(255, 255, 255, 0.5)",
    BORDER_BUTTON: "rgba(255, 255, 255, 0.4)",
    BORDER_BUTTON_HOVER: "rgba(255, 255, 255, 0.6)",
    // Text
    TEXT_PRIMARY: "#ffffff",
    TEXT_SECONDARY: "rgba(255, 255, 255, 0.7)",
    TEXT_PLACEHOLDER: "rgba(255, 255, 255, 0.4)",
    // Status Colors
    STATUS_SUCCESS: "rgba(100, 255, 150, 0.9)",
    STATUS_ERROR: "rgba(255, 100, 100, 0.9)",
    STATUS_WARNING: "rgba(255, 200, 100, 0.9)",
    STATUS_INFO: "rgba(255, 255, 255, 0.6)",
    // Translation element colors
    TRANSLATION_BG: "rgb(22, 30, 42)",
    TRANSLATION_TEXT: "rgb(209, 233, 239)",
    TRANSLATION_BORDER: "rgb(79, 145, 162)"
  },
  // Default Language Settings
  DEFAULTS: {
    ROOM_LANGUAGE: "en",
    MY_LANGUAGE: "ru"
  },
  // UI Text
  TEXT: {
    TRANSLATE_BTN: "\u041F\u0435\u0440\u0435\u0432\u0435\u0441\u0442\u0438",
    TRANSLATING: "\u041F\u0435\u0440\u0435\u0432\u043E\u0436\u0443...",
    CONFIGURED: "\u041D\u0430\u0441\u0442\u0440\u043E\u0435\u043D",
    NOT_CONFIGURED: "\u041D\u0435 \u043D\u0430\u0441\u0442\u0440\u043E\u0435\u043D",
    NOT_SET: "\u041D\u0435 \u0443\u0441\u0442\u0430\u043D\u043E\u0432\u043B\u0435\u043D",
    ACTIVE: "\u0410\u043A\u0442\u0438\u0432\u043D\u0430",
    INACTIVE: "\u041D\u0435\u0430\u043A\u0442\u0438\u0432\u043D\u0430",
    UNKNOWN: "\u041D\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043D\u043E",
    ERROR: "\u041E\u0448\u0438\u0431\u043A\u0430",
    // Error messages
    ERR_ENTER_TEXT: "Please enter some text to translate",
    ERR_CONFIGURE_KEY: "Please configure your API key in extension options",
    ERR_NO_CHAT_INPUT: "Error: Could not find chat input field",
    ERR_API_KEY_REQUIRED: "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 API \u043A\u043B\u044E\u0447",
    ERR_INVALID_API_KEY: "Invalid API key. Please check your API key in extension options.",
    ERR_API_FORBIDDEN: "API key is not authorized to use this service.",
    ERR_NO_API_KEY: "API key not configured. Please set it in extension options.",
    ERR_INVALID_RESPONSE: "Invalid API response format",
    // Success messages
    SUCCESS_SETTINGS_SAVED: "\u041D\u0430\u0441\u0442\u0440\u043E\u0439\u043A\u0438 \u0441\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u044B \u0443\u0441\u043F\u0435\u0448\u043D\u043E!",
    SUCCESS_API_KEY_CLEARED: "API \u043A\u043B\u044E\u0447 \u043E\u0447\u0438\u0449\u0435\u043D",
    // Info messages
    INFO_TESTING_KEY: "\u041F\u0440\u043E\u0432\u0435\u0440\u043A\u0430 API \u043A\u043B\u044E\u0447\u0430 \u0438 \u0441\u043E\u0435\u0434\u0438\u043D\u0435\u043D\u0438\u044F...",
    INFO_EXTENSION_READY: "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043D\u0438\u0435 \u0433\u043E\u0442\u043E\u0432\u043E! \u0418\u043D\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430 \u043F\u043E\u044F\u0432\u0438\u0442\u0441\u044F, \u0435\u0441\u043B\u0438 \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u043D\u0430\u0439\u0434\u0435\u043D\u043E \u043F\u043E\u043B\u0435 \u0432\u0432\u043E\u0434\u0430 \u0447\u0430\u0442\u0430.",
    INFO_CONFIGURE_KEY: '\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u043D\u0430\u0441\u0442\u0440\u043E\u0439\u0442\u0435 \u0432\u0430\u0448 API \u043A\u043B\u044E\u0447 \u0434\u043B\u044F \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u043D\u0438\u044F \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430. \u041D\u0430\u0436\u043C\u0438\u0442\u0435 "\u041D\u0430\u0441\u0442\u0440\u043E\u0438\u0442\u044C API \u043A\u043B\u044E\u0447" \u043D\u0438\u0436\u0435.',
    // Placeholders
    PLACEHOLDER_INPUT: "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0440\u0443\u0441\u0441\u043A\u0438\u0439 \u0442\u0435\u043A\u0441\u0442 \u0434\u043B\u044F \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430..."
  }
};

// popup.js
var C = Config;
var apiKeyStatusSpan = document.getElementById("apiKeyStatus");
var tabStatusSpan = document.getElementById("tabStatus");
var versionSpan = document.getElementById("version");
var infoText = document.getElementById("infoText");
var optionsBtn = document.getElementById("optionsBtn");
var helpBtn = document.getElementById("helpBtn");
versionSpan.textContent = `v${chrome.runtime.getManifest().version}`;
async function checkApiKey() {
  try {
    const result = await chrome.storage.sync.get(["apiKey"]);
    if (result.apiKey) {
      apiKeyStatusSpan.textContent = C.TEXT.CONFIGURED;
      apiKeyStatusSpan.className = "status-value active";
      return true;
    } else {
      apiKeyStatusSpan.textContent = C.TEXT.NOT_SET;
      apiKeyStatusSpan.className = "status-value inactive";
      return false;
    }
  } catch (error) {
    apiKeyStatusSpan.textContent = C.TEXT.ERROR;
    apiKeyStatusSpan.className = "status-value inactive";
    return false;
  }
}
async function checkCurrentTab() {
  try {
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    if (tab && tab.url) {
      tabStatusSpan.textContent = C.TEXT.ACTIVE;
      tabStatusSpan.className = "status-value active";
      return true;
    } else {
      tabStatusSpan.textContent = C.TEXT.INACTIVE;
      tabStatusSpan.className = "status-value inactive";
      return false;
    }
  } catch (error) {
    tabStatusSpan.textContent = C.TEXT.UNKNOWN;
    tabStatusSpan.className = "status-value inactive";
    return false;
  }
}
async function updateInfoText() {
  const hasApiKey = await checkApiKey();
  await checkCurrentTab();
  if (!hasApiKey) {
    infoText.textContent = "\u26A0\uFE0F " + C.TEXT.INFO_CONFIGURE_KEY;
  } else {
    infoText.textContent = "\u2713 " + C.TEXT.INFO_EXTENSION_READY;
  }
}
function openOptions() {
  chrome.runtime.openOptionsPage();
}
function showHelp() {
  const helpMessage = [
    "\u041A\u0430\u043A \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u044C \u041F\u043E\u043C\u043E\u0449\u043D\u0438\u043A \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0447\u0438\u043A\u0430 \u0447\u0430\u0442\u0430:",
    "",
    "1. \u041D\u0430\u0441\u0442\u0440\u043E\u0439\u0442\u0435 \u0432\u0430\u0448 API \u043A\u043B\u044E\u0447 (\u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E)",
    "2. \u041F\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043D\u0430 \u0441\u0430\u0439\u0442 \u0441 \u0441\u043E\u0432\u043C\u0435\u0441\u0442\u0438\u043C\u044B\u043C \u0438\u043D\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043E\u043C \u0447\u0430\u0442\u0430 \u0432\u0435\u0449\u0430\u0442\u0435\u043B\u0435\u0439",
    "3. \u041D\u0430\u0439\u0434\u0438\u0442\u0435 \u043F\u043E\u043B\u0435 \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430 \u043F\u043E\u0434 \u043F\u043E\u043B\u0435\u043C \u0432\u0432\u043E\u0434\u0430 \u0447\u0430\u0442\u0430 (\u0435\u0441\u043B\u0438 \u0434\u043E\u0441\u0442\u0443\u043F\u043D\u043E)",
    "4. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043A\u0441\u0442 \u043D\u0430 \u0432\u0430\u0448\u0435\u043C \u044F\u0437\u044B\u043A\u0435 \u0432 \u043F\u043E\u043B\u0435 \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430",
    "5. \u041D\u0430\u0436\u043C\u0438\u0442\u0435 \u043A\u043D\u043E\u043F\u043A\u0443 \u043F\u0435\u0440\u0435\u0432\u043E\u0434\u0430 \u0438\u043B\u0438 \u043A\u043B\u0430\u0432\u0438\u0448\u0443 Enter",
    "6. \u041F\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043D\u043D\u044B\u0439 \u0442\u0435\u043A\u0441\u0442 \u043F\u043E\u044F\u0432\u0438\u0442\u0441\u044F \u0432 \u043F\u043E\u043B\u0435 \u0432\u0432\u043E\u0434\u0430 \u0447\u0430\u0442\u0430",
    "",
    "\u041D\u0443\u0436\u0435\u043D API \u043A\u043B\u044E\u0447? \u0421\u0432\u044F\u0436\u0438\u0442\u0435\u0441\u044C \u0441 \u0440\u0430\u0437\u0440\u0430\u0431\u043E\u0442\u0447\u0438\u043A\u043E\u043C."
  ].join("\n");
  alert(helpMessage);
}
optionsBtn.addEventListener("click", openOptions);
helpBtn.addEventListener("click", showHelp);
updateInfoText();
