/**
 * WebSocket hook - intercepts tip notifications
 * Runs in MAIN world, dispatches events to content script
 */
(function() {
    'use strict';

    if (window.__cbTranslateWsHooked) return;
    window.__cbTranslateWsHooked = true;

    function handleMessage(data) {
        try {
            const parsed = JSON.parse(data);
            if (!parsed.messages?.length) return;

            for (const msg of parsed.messages) {
                if (!msg.data) continue;
                try {
                    const inner = JSON.parse(msg.data);
                    if (inner._topic === 'RoomTipAlertTopic') {
                        window.dispatchEvent(new CustomEvent('cb-translate-tip', {
                            detail: inner
                        }));
                    }
                } catch {}
            }
        } catch {}
    }

    const OriginalWebSocket = window.WebSocket;
    const origOnMessageDesc = Object.getOwnPropertyDescriptor(OriginalWebSocket.prototype, 'onmessage');

    Object.defineProperty(OriginalWebSocket.prototype, 'onmessage', {
        get: origOnMessageDesc.get,
        set(handler) {
            const wrapped = function(event) {
                handleMessage(event.data);
                return handler?.apply(this, arguments);
            };
            origOnMessageDesc.set.call(this, wrapped);
        },
        configurable: true,
        enumerable: true
    });

    window.WebSocket = function(...args) {
        return new OriginalWebSocket(...args);
    };
    window.WebSocket.prototype = OriginalWebSocket.prototype;
    window.WebSocket.CONNECTING = OriginalWebSocket.CONNECTING;
    window.WebSocket.OPEN = OriginalWebSocket.OPEN;
    window.WebSocket.CLOSING = OriginalWebSocket.CLOSING;
    window.WebSocket.CLOSED = OriginalWebSocket.CLOSED;
})();
